---
generated_at: 2026-02-03 12:00:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：18-Pending Cluster Tasks Report

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **セキュリティ権限名**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `server/src/main/java/org/opensearch/rest/action/cat/RestPendingClusterTasksAction.java` 行60-62（ルート定義）
- E-02: `server/src/main/java/org/opensearch/rest/action/cat/RestPendingClusterTasksAction.java` 行75-91（doCatRequest処理）
- E-03: `server/src/main/java/org/opensearch/rest/action/cat/RestPendingClusterTasksAction.java` 行76-81（パラメータ設定）
- E-04: `server/src/main/java/org/opensearch/rest/action/cat/RestPendingClusterTasksAction.java` 行94-103（テーブルヘッダー定義）
- E-05: `server/src/main/java/org/opensearch/rest/action/cat/RestPendingClusterTasksAction.java` 行97（insertOrder alias: o, 右寄せ）
- E-06: `server/src/main/java/org/opensearch/rest/action/cat/RestPendingClusterTasksAction.java` 行98（timeInQueue alias: t, 右寄せ）
- E-07: `server/src/main/java/org/opensearch/rest/action/cat/RestPendingClusterTasksAction.java` 行99（priority alias: p）
- E-08: `server/src/main/java/org/opensearch/rest/action/cat/RestPendingClusterTasksAction.java` 行100（source alias: s）
- E-09: `server/src/main/java/org/opensearch/rest/action/cat/RestPendingClusterTasksAction.java` 行105-118（buildTable処理）
- E-10: `server/src/main/java/org/opensearch/rest/action/cat/RestPendingClusterTasksAction.java` 行108（for-eachループ）
- E-11: `docs/code-to-docs/帳票一覧/帳票一覧.csv` 行19（帳票定義）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | エンドポイントは /_cat/pending_tasks | E-01 | ○ |
| C-02 | PendingClusterTasksRequestを使用 | E-02 | ○ |
| C-03 | cluster_manager_timeoutパラメータ対応 | E-03 | ○ |
| C-04 | localパラメータ対応 | E-03 | ○ |
| C-05 | テーブルカラムは insertOrder, timeInQueue, priority, source の4つ | E-04 | ○ |
| C-06 | insertOrder aliasは o で右寄せ | E-05 | ○ |
| C-07 | timeInQueue aliasは t で右寄せ | E-06 | ○ |
| C-08 | priority aliasは p | E-07 | ○ |
| C-09 | source aliasは s | E-08 | ○ |
| C-10 | PendingClusterTasksResponseはIterable（for-each直接利用） | E-10 | ○ |
| C-11 | アクション名は cat_pending_cluster_tasks_action | E-01 | ○ |
| C-12 | ソースファイルは全119行 | E-09 | ○ |
| C-13 | 帳票名は「Pending Cluster Tasks Report」 | E-11 | ○ |
| C-14 | master_timeoutは非推奨 | E-03 | ○ |
| C-15 | cluster:monitor/task 権限が必要 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- セキュリティ権限名はSecurity pluginに依存
  - 候補：Security plugin documentation / Permission mapping

## 5) リスクフラグ（レビュー観点）
- 0: エンドポイント・カラム定義・処理フロー（ソースコード確認済み）
- 1: セキュリティ権限名（推定値）

## 6) レビュアーチェックリスト（最小）
- [ ] テーブルカラム4つの定義が正確か確認
- [ ] セキュリティ権限名の確認
